// Set the date we're counting down to
var countDownDate = new Date("Apr 18, 2019 10:00:00").getTime();  // CHANGE DATE AND TIME HERE

// Update the count down every 1 second
var countdown = setInterval(function() {

  // Get todays date and time
  var now = new Date().getTime();

  // Find the difference between now and the count down date
  var difference = countDownDate - now;

  // Time calculations for days, hours, minutes and seconds
  var days = Math.floor(difference / (1000 * 60 * 60 * 24));
  var hours = Math.floor((difference % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  var minutes = Math.floor((difference % (1000 * 60 * 60)) / (1000 * 60));
  var seconds = Math.floor((difference % (1000 * 60)) / 1000);

  // If the difference is less than 0, stop countdown
  if (difference < 0) {
    clearInterval(countdown);
    days = 0, hours = 0, minutes = 0, seconds = 0;
  }

  // Output the result
  document.getElementById("days").children[0].innerText = days;
  document.getElementById("hours").children[0].innerText = hours;
  document.getElementById("minutes").children[0].innerText = minutes;
  document.getElementById("seconds").children[0].innerText = seconds;
}, 1000);